'PLOTLIB
'	THIS MODULE CONTAINS THE ROUTINES THAT ACTUAL GENERATE
'	HPGL INSTRUCTIONS TO THE PLOTTER (OR DISK FILE).  USED
'	BY ALL ROUTINES THAT DO PLOTTING
'
OPTION BASE 1
DEFSNG A-Z
DECLARE FUNCTION SNGMIN(A,B)
DECLARE FUNCTION SNGMAX(A,B)
DECLARE FUNCTION CNVRAS%(XT,XSHIFT)
SUB PrintDisclaimer STATIC
	LOCATE 14,29:PRINT "     DISCLAIMER          "
	LOCATE 16,10:PRINT "Although program tests have been made, no guarantee (expressed";
	LOCATE 17,10:PRINT "or implied) is made by the author regarding program correctness,";
	LOCATE 18,10:PRINT "accuracy, or proper execution on all computer systems.";
	SLEEP 1
END SUB
SUB GetDataBaseName(FILNAM$) STATIC
	CLS
GDBN1:	INPUT "ENTER MAP DATA BASE NAME: ", FILNAM$
	K%=INSTR(1,FILNAM$," ")
	IF K%<>0 AND FILNAM$<>"" THEN
		PRINT "ENTRY CONTAINS A BLANK. AN INVALID DOS FILENAME"
		PRINT "WOULD BE CREATED - PLEASE RE-ENTER"
		GOTO GDBN1
	END IF
END SUB
SUB SetupScreenParameters(TDISP$,TD%,SCRH%,SCRV%,ASPRAT,KCOLR%(1)) STATIC
	FOR IJK%=1 TO 699
		KCOLR%(IJK%)=1
	NEXT IJK%
	INPUT #1,TDISP$
	IF TDISP$ = "CGAC" THEN
		TD% = 2
		SCRH% = 639
		SCRV% = 190
		ASPRAT= 480/200
	ELSEIF TDISP$ = "CGAM" THEN
		TD% = 2
		SCRH% = 639
		SCRV% = 190
		ASPRAT=480/200
	ELSEIF TDISP$ = "CIII" THEN
		TD% = 2
		SCRH% = 639
		SCRV% = 190
		ASPRAT=2.04
	ELSEIF TDISP$ = "EGAM" THEN
		TD% = 10
		SCRH% = 639
		SCRV% = 330
		ASPRAT=480/350
	' FOLLOWING ASSUMES TDISP$ = "EGAC"
	ELSEIF TDISP$ = "EGAC" THEN
		TD%=9
		SCRH% = 639
		SCRV%=330
		ASPRAT=480/350
GOFER: 		IEOF%=EOF(1)
		IF IEOF%>=0 THEN
			INPUT#1, ILT%, ISCC%
			KCOLR%(ILT%) = ISCC%
			GOTO GOFER
		END IF
	ELSE
		TD% = 2
		SCRH% = 639
		SCRV% = 190
		ASPRAT= 480/200
	END IF
	CLOSE #1
END SUB
SUB CheckLineAgainstWindow(ICNT%,XD(1),YD(1),MXSCALE,MYSCALE,XOFF,YOFF,XSHIFT,YSHIFT,_
	XWMIN,XWMAX,YWMIN,YWMAX) STATIC
' PLOT LINE CHECKING AGAINST WINDOW
	WX2=0:WX3=0:WY2=0:WY3=0
	WX4=XD(1):WY4=YD(1):WX1=WX4:WY1=WY4
	CALL CheckPointAgainstWindow(WCODE1%,WX1,WY1,XWMIN,XWMAX,YWMIN,YWMAX)
	WCODE4%=WCODE1%
	FOR J%=2 TO ICNT%
		WX2=WX4:WY2=WY4:WCODE2%=WCODE4%:WX1=XD(J%):WY1=YD(J%)
		WX4=WX1:WY4=WY1
		CALL CheckPointAgainstWindow(WCODE1%,WX1,WY1,XWMIN,XWMAX,YWMIN,YWMAX)
		WCODE4%=WCODE1%: EXCHANGE=-1
8840		IF WCODE1%=0 AND WCODE2%=0 GOTO 8920
		IF (WCODE1% AND WCODE2%) GOTO 9000
		IF WCODE1%=0 THEN CALL SwapPoints(WCODE1%,WCODE2%,WX1,WY1,WX2,WY2,EXCHANGE)
		IF WCODE1% AND 8 THEN WX1=WX1+(WX2-WX1)*(YWMAX-WY1)/(WY2-WY1):WY1=YWMAX:GOTO 8910
		IF WCODE1% AND 4 THEN WX1=WX1+(WX2-WX1)*(YWMIN-WY1)/(WY2-WY1):WY1=YWMIN:GOTO 8910
		IF WCODE1% AND 2 THEN WY1=WY1+(WY2-WY1)*(XWMAX-WX1)/(WX2-WX1):WX1=XWMAX:GOTO 8910
		IF WCODE1% AND 1 THEN WY1=WY1+(WY2-WY1)*(XWMIN-WX1)/(WX2-WX1):WX1=XWMIN
8910		CALL CheckPointAgainstWindow(WCODE1%,WX1,WY1,XWMIN,XWMAX,YWMIN,YWMAX)
		GOTO 8840
8920		IF EXCHANGE=1 THEN CALL SwapPoints(WCODE1%,WCODE2%,WX1,WY1,WX2,WY2,EXCHANGE)
		WXP=WX1:WYP=WY1
		WXP%=CNVRAS%(WXP+XOFF,XSHIFT):WYP%=CNVRAS%(WYP+YOFF,YSHIFT)
		IF WX2=WX3 AND WY2=WY3 THEN CALL LineTo(0,WXP%,WYP%): GOTO 9000
		WXP1%=WXP%:WYP1%=WYP%
		WXP=WX2:WYP=WY2
		WXP%=CNVRAS%(WXP+XOFF,XSHIFT):WYP%=CNVRAS%(WYP+YOFF,YSHIFT)
		CALL MoveTo(0,WXP%,WYP%)
		CALL LineTo(0,WXP1%,WYP1%)
9000		WX3=WX1:WY3=WY1
	NEXT J%
	CALL SetPenStatus(0)
END SUB
SUB HATCH(N%,X(1),Y(1),X0(1),Y0(1),ANGLE,GAB,MXSCALE,MYSCALE, _
		XOFF,YOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX) STATIC
'********************************************************
' PARAMETER DEFINITIONS:
' N%    = NUMBER OF POINTS IN POLYGON
' X()   = X COORDINATES
' Y()   = Y COORDINATES
' ANGLE = DIRECTION OF FILL IN DEGREES
' GAB   = SPACING OF FILL IN INCHES
' REFERENCE: B. FRANKLIN, UNIVERSITY OF BRITISH COLUMBIA
'********************************************************
	DIM XR(200),XH(2),YH(2),PP(4)
	IF GAB=0.0 GOTO 999
	THETA=ANGLE*0.01745329
	C=COS(THETA)
	SS=SIN(THETA)
'
' FIND MIN,MAX OF POLYGON
'
	HXMIN=99999999.
	HYMIN=XMIN
	HXMAX=-1*XMIN
	HYMAX=XMAX
	FOR IJK%=1 TO N%
		HXMIN=SNGMIN(HXMIN,X(IJK%))
		HYMIN=SNGMIN(HYMIN,Y(IJK%))
		HXMAX=SNGMAX(HXMAX,X(IJK%))
		HYMAX=SNGMAX(HYMAX,Y(IJK%))
	NEXT IJK%
'
	PP(1)= -HXMIN*SS +HYMIN*C
	PP(2)=-HXMIN*SS + HYMAX*C
	PP(3)=-HXMAX*SS + HYMAX*C
	PP(4)=-HXMAX*SS + HYMIN*C
	PLO=PP(1)
	PHI=PP(1)
	FOR IJK%=2 TO 4
		IF PP(IJK%)<PLO THEN PLO=PP(IJK%)
		IF PP(IJK%)>PHI THEN PHI=PP(IJK%)
	NEXT IJK%
	LO=99999999.
	HI=-1*LO
	FOR IJK%=1 TO N%
		X0(IJK%)=X(IJK%)*C + Y(IJK%)*SS
		Y0(IJK%)=-X(IJK%)*SS + Y(IJK%)*C
		P=Y0(IJK%)
		IF P<PLO THEN P=PLO
		IF P>PHI THEN P=PHI
		IF P<LO THEN LO=P
		IF P>HI THEN HI=P
	NEXT IJK%
	P=PLO - GAB/2
	I%=0
50	I%=I%+1
	P=P+GAB
	IF P<LO GOTO 50
	IF P>HI GOTO 999
	M%=0
	IS4%=1
	IE%=N%
LP0:    XSAV=X0(IS4%)
	YSAV=Y0(IS4%)
	FOR I%=IS4%+1 TO N% 
		IF (X0(I%)=XSAV) AND (Y0(I%)=YSAV) THEN
			IE%=I%
			GOTO LP1
		END IF
	NEXT I%
	IE%=N%
LP1:	SJ=Y0(IS4%)
	FOR IJK%=IS4% TO IE%-1
		J%=IJK%+ 1
		S1=SJ
		SJ=Y0(J%)
		IF ((S1<=P) AND (SJ<=P)) GOTO 70
		IF ((S1>P) AND (SJ>P)) GOTO 70
		M%=M%+1
		IF M%>200 GOTO 900
		XR(M%) = X0(IJK%) + (X0(J%)-X0(IJK%)) * (P-S1)/(SJ-S1)
70      NEXT IJK%
	IS4%=IE%+1
	IF IS4%<N% GOTO LP0
	IF M%=0 GOTO 50
' 
' SORT IN ASCENDING ORDER
'
90	IFLAG=0
	FOR IJK%=2 TO M%
		IF XR(IJK%-1) > XR(IJK%) THEN
			IFLAG=1
			Q=XR(IJK%)
			XR(IJK%)=XR(IJK%-1)
			XR(IJK%-1)=Q
		END IF
	NEXT IJK%
	IF IFLAG<>0 GOTO 90
	IF (I% MOD 2%) = 0 THEN
		L%=-1
		NS%=M%+1
	ELSE
		L%=1
		NS%=0
	END IF
	FOR J%=2 TO M% STEP 2
		FOR JJ%=1 TO 2
			NS%=NS%+L%
			XH(JJ%)=XR(NS%)*C - P*SS
			YH(JJ%)=XR(NS%)*SS + P*C
		NEXT JJ%
		WX1=XH(1)
		WY1=YH(1)
		CALL CheckPointAgainstWindow(WCODE1%,WX1,WY1,XWMIN,XWMAX,YWMIN,YWMAX)
		IF WCODE1%=0 THEN
			XT%=CNVRAS%(WX1+XOFF,XSHIFT)
			YT%=CNVRAS%(WY1+YOFF,YSHIFT)
			CALL MoveTo(0,XT%,YT%)
		END IF
		NGARY%=2
		CALL CheckLineAgainstWindow(NGARY%,XH(),YH(),MXSCALE,MYSCALE, _
			XOFF,YOFF,XSHIFT,YSHIFT,XWMIN,XWMAX,YWMIN,YWMAX)
		CALL SetPenStatus(0)
	NEXT J%
	GOTO 50
900	PRINT "MORE THAN 200 INTERSECTIONS"
999     END SUB
SUB SHATCH(N%,X(1),Y(1)) STATIC
'********************************************************
' SPECIAL VERSION OF HATCH TO FILL SYMBOLS
' PARAMETER DEFINITIONS:
' N%    = NUMBER OF POINTS IN SYMBOL
' X()   = X COORDINATES
' Y()   = Y COORDINATES
' REFERENCE: B. FRANKLIN, UNIVERSITY OF BRITISH COLUMBIA
'********************************************************
	DIM XR(200),XH(2),YH(2)
'
' FIND MIN,MAX OF POLYGON
'
	PLO=99999999.
	PHI=-1*PLO
	FOR IJK%=1 TO N%
		PLO=SNGMIN(PLO,Y(IJK%))
		PHI=SNGMAX(PHI,Y(IJK%))
	NEXT IJK%
	GAB=8
	P=PLO - GAB/2
	I%=0
SH50:      I%=I%+1
	P=P+GAB
	IF P<PLO GOTO SH50
	IF P>PHI GOTO SH999
	M%=0
	IS4%=1
	IE%=N%
SHLP0:    XSAV=X(IS4%)
	YSAV=Y(IS4%)
	FOR I%=IS4%+1 TO N% 
		IF (X(I%)=XSAV) AND (Y(I%)=YSAV) THEN
			IE%=I%
			GOTO SHLP1
		END IF
	NEXT I%
	IE%=N%
SHLP1:    SJ=Y(IS4%)
	FOR IJK%=IS4% TO IE%-1
		J%=IJK%+ 1
		S1=SJ
		SJ=Y(J%)
		IF ((S1<=P) AND (SJ<=P)) GOTO SH70
		IF ((S1>P) AND (SJ>P)) GOTO SH70
		M%=M%+1
		IF M%>200 GOTO SH900
		XR(M%) = X(IJK%) + (X(J%)-X(IJK%)) * (P-S1)/(SJ-S1)
SH70:      NEXT IJK%
	IS4%=IE%+1
	IF IS4%<N% GOTO SHLP0
	IF M%=0 GOTO SH50
' 
' SORT IN ASCENDING ORDER
'
SH90:      IFLAG=0
	FOR IJK%=2 TO M%
		IF XR(IJK%-1) > XR(IJK%) THEN
			IFLAG=1
			Q=XR(IJK%)
			XR(IJK%)=XR(IJK%-1)
			XR(IJK%-1)=Q
		END IF
	NEXT IJK%
	IF IFLAG<>0 GOTO SH90
	IF (I% MOD 2%) = 0 THEN
		L%=-1
		NS%=M%+1
	ELSE
		L%=1
		NS%=0
	END IF
	FOR J%=2 TO M% STEP 2
		FOR JJ%=1 TO 2
			NS%=NS%+L%
			XH(JJ%)=XR(NS%)
			YH(JJ%)=P
		NEXT JJ%
			XP%=XH(1):YP%=YH(1)
			CALL MoveTo(0,XP%,YP%)
			XP%=XH(2):YP%=YH(2)
			CALL LineTo(0,XP%,YP%)
			CALL SetPenStatus(0)
	NEXT J%
	GOTO SH50
SH900:     PRINT "MORE THAN 200 INTERSECTIONS"
SH999:     END SUB
SUB ZHATCH(N%,X(1),Y(1),XSPACE,YSPACE,MXSCALE,MYSCALE, _
	XOFF,YOFF,XSHIFT,YSHIFT,XWMIN,YWMIN,XWMAX,YWMAX, _
	OPT6%,RN$,JSYM%,SYMSIZE,NSP%,PS$(1),XSYM(1),YSYM(1)) STATIC
'********************************************************
' SPECIAL VERSION OF HATCH TO FILL POLYGONS
' WITH ZIPTONE PATTERN
' PARAMETER DEFINITIONS:
' N%    = NUMBER OF POINTS IN SYMBOL
' X()   = X COORDINATES
' Y()   = Y COORDINATES
' XSPACE= DISTANCE BETWEEN SYMBOLS IN X DIR
' YSPACE= DISTANCE BETWEEN LINES OF SYMBOLS IN Y DIR
' REFERENCE: B. FRANKLIN, UNIVERSITY OF BRITISH COLUMBIA
'********************************************************
	DIM XR(200),XH(2),YH(2),TPX%(25),TPY%(25)
'
' FIND MIN,MAX OF POLYGON
'
	PLO=99999999.
	PHI=-1*PLO
	FOR IJK%=1 TO N%
		PLO=SNGMIN(PLO,Y(IJK%))
		PHI=SNGMAX(PHI,Y(IJK%))
	NEXT IJK%
	GAB=YSPACE/2
	P=PLO - GAB/2
	I%=0
ZH50:      I%=I%+1
	P=P+GAB
	IF P<PLO GOTO ZH50
	IF P>PHI GOTO ZH999
	M%=0
	IS4%=1
	IE%=N%
ZHLP0:    XSAV=X(IS4%)
	YSAV=Y(IS4%)
	FOR IJK%=IS4%+1 TO N% 
		IF (X(IJK%)=XSAV) AND (Y(IJK%)=YSAV) THEN
			IE%=IJK%
			GOTO ZHLP1
		END IF
	NEXT IJK%
	IE%=N%
ZHLP1:    SJ=Y(IS4%)
	FOR IJK%=IS4% TO IE%-1
		J%=IJK%+ 1
		S1=SJ
		SJ=Y(J%)
		IF ((S1<=P) AND (SJ<=P)) GOTO ZH70
		IF ((S1>P) AND (SJ>P)) GOTO ZH70
		M%=M%+1
		IF M%>200 GOTO ZH900
		XR(M%) = X(IJK%) + (X(J%)-X(IJK%)) * (P-S1)/(SJ-S1)
ZH70:      NEXT IJK%
	IS4%=IE%+1
	IF IS4%<N% GOTO ZHLP0
	IF M%=0 GOTO ZH50
' 
' SORT IN ASCENDING ORDER
'
ZH90:      IFLAG=0
	FOR IJK%=2 TO M%
		IF XR(IJK%-1) > XR(IJK%) THEN
			IFLAG=1
			Q=XR(IJK%)
			XR(IJK%)=XR(IJK%-1)
			XR(IJK%-1)=Q
		END IF
	NEXT IJK%
	IF IFLAG<>0 GOTO ZH90
	IF (I% MOD 2%) = 0 THEN
		L%=-1
		NS%=M%+1
	ELSE
		L%=1
		NS%=0
	END IF
	FOR J%=2 TO M% STEP 2
		FOR JJ%=1 TO 2
			NS%=NS%+L%
			XH(JJ%)=XR(NS%)
			YH(JJ%)=P
		NEXT JJ%
		XP=XH(1)-(0.5*XSPACE)
		YP=P
ZHLP:		XP=XP + XSPACE
		IF XP<=(XH(2)-(0.5*XSPACE)) THEN
			CALL CheckPointAgainstWindow(WCODE1%,XP,YP,XWMIN,XWMAX,YWMIN,YWMAX)
			IF WCODE1%=0 THEN
				XP%=CNVRAS%(XP+XOFF,XSHIFT)
				YP%=CNVRAS%(YP+YOFF,YSHIFT)
				IF RN$="Y" THEN 
					ANG=RND*6.2831853!
				ELSE
					ANG=0.0
				END IF
				CALL MoveTo(0,XP%,YP%)
				CALL RotateASymbol(ANG,JSYM%,NSP%,PS$(),XSYM(),YSYM(),TPX%(),TPY%())
				CALL PlotASymbol(XP%,YP%,JSYM%,SYMSIZE,NSP%,PS$(),TPX%(),TPY%(),OPT6%)
			END IF
			CALL SetPenStatus(0)
			GOTO ZHLP
		END IF
	NEXT J%
	GOTO ZH50
ZH900:     PRINT "MORE THAN 200 INTERSECTIONS"
ZH999:     END SUB
SUB DrawLineOnScreen(CHOICE%,ICNT%,XPI!(1),YPI!(1),COLR%,LCODE!) STATIC
' ROUTINE TO DRAW LINESS ON SCREEN
' NOTE! IF CHOICE IS 8 THEN INTERIOR ISLANDS ARE NOT CONNECTED
' TO THE EXTERIOR POLYGON AND TO SUBSEQUENT INTERIOR POLYGONS
'
		XSAV=XPI!(1)
		YSAV=YPI!(1)
		P%=0
		FOR IJK%=1 TO ICNT%
			XP=XPI!(IJK%)
			YP=YPI!(IJK%)
			IF P%=1 OR IJK% = 1 OR (LCODE!>=300 AND LCODE!<=399) THEN
				PSET (XP,YP),COLR%
				P%=0%
				XSAV=XP
				YSAV=YP
			ELSE
				LINE -(XP,YP),COLR%
				IF CHOICE%=8 AND XSAV=XP AND YSAV=YP THEN
					P%=1%
				END IF
			END IF
		NEXT IJK%
END SUB
SUB SCHATCH(N%,X(1),Y(1),COL%) STATIC
'********************************************************
' SPECIAL VERSION OF HATCH TO FILL POLYGONS ON SCREEN
' PARAMETER DEFINITIONS:
' N%    = NUMBER OF POINTS IN POLYGON
' X()   = X COORDINATES
' Y()   = Y COORDINATES
' COL%  = COLOR
' REFERENCE: B. FRANKLIN, UNIVERSITY OF BRITISH COLUMBIA
'********************************************************
' $DYNAMIC
	DIM XR(200),XH(2),YH(2)
' $STATIC
'
' FIND MIN,MAX OF POLYGON
'
	IF N%<3 GOTO SCH999
	PLO=1.0E23
	PHI=-1*PLO
	FOR IJK%=1 TO N%
		PLO=SNGMIN(PLO,Y(IJK%))
		PHI=SNGMAX(PHI,Y(IJK%))
	NEXT IJK%
	GAB=(PHI-PLO)/4.
	P=PLO-GAB/2.
SCH50:	P=P+GAB
	IF P<=PLO GOTO SCH50
	IF P>=PHI GOTO SCH999
	M%=0
	IS4%=1
	IE%=N%
SCHLP0:    XSAV=X(IS4%)
	YSAV=Y(IS4%)
	FOR I%=IS4%+1 TO N% 
		IF (X(I%)=XSAV) AND (Y(I%)=YSAV) THEN
			IE%=I%
			GOTO SCHLP1
		END IF
	NEXT I%
	IE%=N%
SCHLP1:    SJ=Y(IS4%)
	FOR IJK%=IS4% TO IE%-1
		J%=IJK%+ 1
		SI=SJ
		SJ=Y(J%)
		IF SI=SJ GOTO SCH70
		IF ((SI<=P) AND (SJ<=P)) GOTO SCH70
		IF ((SI>=P) AND (SJ>=P)) GOTO SCH70
		M%=M%+1
		IF M%>200 GOTO SCH900
		XR(M%) = X(IJK%) + (X(J%)-X(IJK%)) * (P-SI)/(SJ-SI)
SCH70:      NEXT IJK%
	IS4%=IE%+1
	IF IS4%<N% GOTO SCHLP0
	IF M%=0 GOTO SCH50
' 
' SORT IN ASCENDING ORDER
'
SCH90:      IFLAG=0
	FOR IJK%=2 TO M%
		IF XR(IJK%-1) > XR(IJK%) THEN
			IFLAG=1
			Q=XR(IJK%)
			XR(IJK%)=XR(IJK%-1)
			XR(IJK%-1)=Q
		END IF
	NEXT IJK%
	IF IFLAG<>0 GOTO SCH90
	FOR J%=2 TO M% STEP 2
		XH(1)=XR(J%-1)
		XH(2)=XR(J%)
		YH(1)=P
		YH(2)=P
		IF XH(1)<>XH(2) THEN
			XP=XH(1)+((XH(2)-XH(1))/2.)
			YP=P
			IF POINT(XP,YP)<>COL% THEN
				CALL PTLOC(IE%,XP,YP,X(),Y(),RESULT)
				IF RESULT=1 THEN
					 PAINT (XP,YP),COL%,COL%
				END IF
			END IF
		END IF
	NEXT J%
	GOTO SCH50
SCH900:     PRINT "MORE THAN 200 INTERSECTIONS"
SCH999:     ERASE XR,XH,YH
END SUB
	SUB PRESPLINE(XD(1),YD(1),T(1),ICNT%,SPLINESIZE%) STATIC
		T(1)=0.0
LP:		FOR I%=2 TO ICNT%
			DIFX=XD(I%)-XD(I%-1)
			DIFY=YD(I%)-YD(I%-1)
			IF (DIFX = 0.0) AND (DIFY = 0.0) THEN
				FOR J%=I% TO ICNT%-1
					XD(J%)=XD(J%+1)
					YD(J%)=YD(J%+1)
				NEXT J%
				ICNT%=ICNT%-1
				GOTO LP
			ELSE
				T(I%)=T(I%-1)+SQR(DIFX*DIFX + DIFY*DIFY)
			END IF
		NEXT I%
		SPLINESIZE%=INT(8000/ICNT%)*ICNT%
		IF SPLINESIZE%>5*ICNT% THEN SPLINESIZE%=5*ICNT%
		IF SPLINESIZE%>8000 THEN SPLINESIZE%=8000
	END SUB
	SUB SPLINE(F(1),T(1),ICNT%,CALCF(1),SPLINESIZE%) STATIC
	DIM A(500),B(500),C(500)
' COMPUTE FIRST DIFFERENCES
	FOR I%=2 TO ICNT%
		B(I%)=T(I%)-T(I%-1)
		C(I%)=(F(I%)-F(I%-1))/B(I%)
	NEXT I%
' TAKE CARE OF BEGINNING OF CURVE
	C(1)=B(3)
	B(1)=B(2)+B(3)
	A(1)=((B(2)+2*B(1))*C(2)*B(3)+B(2)*B(2)*C(3))/B(1)
' FORWARD PASS OF GAUSSIAN ELIMINATION
	FOR I%=2 TO ICNT%-1
		G=-B(I%+1)/C(I%-1)
		A(I%)=G*A(I%-1)+3*(B(I%)*C(I%+1)+B(I%+1)*C(I%))
		C(I%)=G*B(I%-1)+2*(B(I%)+B(I%+1))
	NEXT I%
' TAKE CARE OF END OF CURVE
	G=B(ICNT%-1)+B(ICNT%)
	A(ICNT%)=((B(ICNT%)+G+G)*C(ICNT%)*B(ICNT%-1)+B(ICNT%)*B(ICNT%)* _
		(F(ICNT%-1)-F(ICNT%-2))/B(ICNT%-1))/G
	G=-G/C(ICNT%-1)
	C(ICNT%)=B(ICNT%-1)
' COMPLETE THE FORWARD PASS
	C(ICNT%)=G*B(ICNT%-1)+C(ICNT%)
	A(ICNT%)=(G*A(ICNT%-1)+A(ICNT%))/C(ICNT%)
' BACK SUBSTITUTION
	FOR I%=ICNT%-1 TO 1 STEP -1
		A(I%)=(A(I%)-B(I%)*A(I%+1))/C(I%)
	NEXT I%
' GENERATE CUBIC COEFFICIENTS
	FOR I%=2 TO ICNT%
		D=(F(I%)-F(I%-1))/B(I%)
		E=A(I%-1)+A(I%)-2*D
		B(I%-1)=2*(D-A(I%-1)-E)/B(I%)
		C(I%-1)=(E/B(I%))*(6./B(I%))
	NEXT I%
' COMPUTE THE POINTS TO BE PLOTTED AS FUNCTION OF WT
	WT=0
	DT=T(ICNT%)/(SPLINESIZE%-1)
	J%=1
	FOR I%=1 TO SPLINESIZE%
LOP:		IF J%<ICNT% THEN
			IF T(J%+1)<WT THEN
				J%=J%+1
				GOTO LOP
			END IF
		END IF
		H=WT-T(J%)
		CALCF(I%)=F(J%)+H*(A(J%)+H*(B(J%)+H*C(J%)/3.)/2.)
' MOVE TO NEXT POINT
		WT=WT+DT
	NEXT I%
	FOR I%=1 TO SPLINESIZE%
		F(I%)=CALCF(I%)
	NEXT I%
END SUB
SUB PTLOC(NP%,XP,YP,XD(1),YD(1),RESULT) STATIC
'*****************************************************************
'***    THIS SUBPROGRAM DETERMINES WHETHER A POINT LIES WITHIN A
'***    CLOSED BOUNDARY.
'***    IF PTLOC =-1  THE POINT IS OUTSIDE.
'***               0  THE POINT LIES ON THE BOUNDARY.
'***               1  THE POINT LIES WITHIN THE BOUNDARY.
'***               2  THE POINT LIES ON A NODE
'***    PROGRAM PTLOC WAS WRITTEN BY JOHN K. HALL OF THE
'***    GEOLOGICAL SURVEY OF ISRAEL. DOCUMENTATION AND
'***    EXPLANATION OF THIS ALGORITHM WERE PUBLISHED IN
'***    MATHEMATICAL GEOLOGY, VOL 7,NO. 1, FEB., 1975
'***    PROGRAM SLIGHTLY MODIFIED BY W.D. GRUNDY,USGS,979, JUNE 1985
'*****************************************************************
      C180=.9999999998D0
      IEC%=0
      TSC=0.0
      SC=0.0
      SC1=0.0
      TCC=1.0
      CC=1.0
      X1=XD(NP%)-XP
      Y1=YD(NP%)-YP
      R1=SQR(X1*X1+Y1*Y1)
	IF X1=0.0 AND Y1=0.0 GOTO PTL150
	FOR I%=1 TO NP%
		X2=XD(I%)-XP
		Y2=YD(I%)-YP
		R2=SQR(X2*X2+Y2*Y2)
		VPL=R1*R2
		IF X2=0.0 AND Y2=0.0 GOTO PTL150
		ST=(X1*Y2-X2*Y1)/VPL
		CT=(X1*X2+Y1*Y2)/VPL
		IF (CT+C180)<=0.0 GOTO PTL130
		IF I%>=NP% THEN
			IF (IEC% MOD 2)<=0 THEN
				GOTO PTL120
			ELSE
				GOTO PTL140
			END IF
		END IF
PTL50:     	TSC=SC*CT+CC*ST
		TCC=CC*CT-SC*ST
		IF ((TSC*SC)>0.0) OR ((TSC*SC1)>0.0) OR ((TSC*ST)>=0.0) GOTO PTL90
		IEC%=IEC%+1
PTL90:		SC=TSC
		CC=TCC
		X1=X2
		Y1=Y2
		R1=R2
		IF SC<>0.0 THEN SC1=SC
PTL110:	NEXT I%
PTL120:	RESULT=-1
      GO TO PTL170
PTL130:	RESULT=0
      GO TO PTL170
PTL140:	RESULT=1
      GO TO PTL170
PTL150:	RESULT=2
PTL170:	END SUB
SUB SwapPoints(WCODE1%,WCODE2%,WX1,WY1,WX2,WY2,EXCHANGE) STATIC
'Subroutine to swap two points used by CheckLineAgainstWindow
	TEMP=WX1:WX1=WX2:WX2=TEMP
	TEMP=WY1:WY1=WY2:WY2=TEMP
	TEMP%=WCODE1%:WCODE1%=WCODE2%:WCODE2%=TEMP%
	EXCHANGE=-1*EXCHANGE
END SUB
SUB CheckPointAgainstWindow(WCODE1%,WX1,WY1,XWMIN,XWMAX,YWMIN,YWMAX) STATIC
' CHECKS TO SEE IF A DATA POINT IN WITHIN THE WINDOW
	WCODE1%=0
	IF WX1<XWMIN THEN WCODE1%=WCODE1%+1
	IF WX1>XWMAX THEN WCODE1%=WCODE1%+2
	IF WY1<YWMIN THEN WCODE1%=WCODE1%+4
	IF WY1>YWMAX THEN WCODE1%=WCODE1%+8
END SUB
SUB LoadASymbol(SYMFIL$,JSYM%,NSP%,PS$(1),XSYM!(1),YSYM!(1)) STATIC
' SUBROUTINE TO LOAD A SYMBOL
		OPEN SYMFIL$ FOR INPUT AS #5
		LINE INPUT #5,DSTRING$
LAS1:    	IEOF%=EOF(5)
		IF IEOF%<0 THEN
			PRINT "SYMBOL ";JSYM%;" NOT FOUND IN ",SYMFIL$," (SYMBOL FILE)"
			IERR=1
		ELSE
			INPUT #5,SYM,NSP%
			FOR IJK%=1 TO NSP%
				INPUT #5,PS$(IJK%),XSYM!(IJK%),YSYM!(IJK%)
			NEXT IJK%
			IF JSYM% = SYM THEN
				IERR=0
			ELSE
				GOTO LAS1
			END IF
		END IF
		CLOSE #5
END SUB
SUB ScaleASymbol(SYMSIZE!,JSYM%,NSP%,PS$(1),XSYM!(1),YSYM!(1)) STATIC
' SUBROUTINE TO SCALE A SYMBOL
		FOR IJK%=1 TO NSP%
			IF PS$(IJK%)<>"PM" THEN
				XSYM!(IJK%)=XSYM!(IJK%)*SYMSIZE!
				YSYM!(IJK%)=YSYM!(IJK%)*SYMSIZE!
			END IF
		NEXT IJK%
END SUB
SUB RotateASymbol(ROTANG,JSYM%,NSP%,PS$(1),XSYM(1),YSYM(1),TX%(1),TY%(1)) STATIC
' SUBROUTINE TO ROTATE A SYMBOL
	COSANG=COS(ROTANG):SINANG=SIN(ROTANG)
	FOR IJK%=1 TO NSP%
		IF PS$(IJK%)="CI" OR PS$(IJK%)="PM" THEN
			TX%(IJK%)=XSYM(IJK%)
			TY%(IJK%)=0
		ELSE
			TX%(IJK%)=XSYM(IJK%)*COSANG+YSYM(IJK%)*SINANG
			TY%(IJK%)=YSYM(IJK%)*COSANG-XSYM(IJK%)*SINANG
		END IF
	NEXT IJK%
END SUB
SUB PlotASymbol(XT%,YT%,JSYM%,SYMSIZE,NSP%,PS$(1),TX%(1),TY%(1),OPT6%) STATIC
' PLOT SYMBOLS
DIM PX(100),PY(100)
	CALL MoveTo(0,XT%,YT%)
	CX%=XT%
	CY%=YT%
	PMODE$="N"
	FOR IJK%=1 TO NSP%
		IX%=TX%(IJK%)
		IY%=TY%(IJK%)
		IF PMODE$="N" THEN
			IF PS$(IJK%)="PU" THEN
				CX%=CX%+IX%
				CY%=CY%+IY%
				CALL MoveTo(0,CX%,CY%)
			ELSEIF PS$(IJK%)="CI" THEN
				IT%=IX%/2
				CALL DrawCircle(IT%)
			ELSEIF PS$(IJK%)="PM" THEN
				IF IX%=0 THEN
					PMODE$="Y"
					IP%=0
				END IF
			ELSE
				CX%=CX%+IX%
				CY%=CY%+IY%
				CALL LineTo(0,CX%,CY%)
			END IF
		ELSE
			IF PS$(IJK%)="PU" THEN
				CX%=CX%+IX%
				CY%=CY%+IY%
				IP%=IP%+1
				PX(IP%)=CX%
				PY(IP%)=CY%
			ELSEIF PS$(IJK%)="CI" THEN
				FOR A=0 TO 360 STEP 5
					AR=0.01745329*A
					SS=SIN(AR)
					CS=COS(AR)
					R=IX%/2
					IP%=IP%+1
					PX(IP%)=CX%+CS*R
					PY(IP%)=CY%+SS*R
				NEXT A
			ELSEIF PS$(IJK%)="PM" THEN
				IF IX%=2 THEN
					IF (PX(IP%)<>PX(1)) OR (PY(IP%)<>PY(1)) THEN
						IP%=IP%+1
						PX(IP%)=PX(1)
						PY(IP%)=PY(1)
					END IF
					CALL SHATCH(IP%,PX(),PY())
					FOR IJ%=1 TO IP%
						PX%=PX(IJ%)
						PY%=PY(IJ%)
						IF IJ%=1 THEN
							CALL MoveTo(0,PX%,PY%)
						ELSE
							CALL LineTo(0,PX%,PY%)
						END IF
					NEXT IJ%
					PMODE$="N"
					IP%=0
				END IF
			ELSE
				CX%=CX%+IX%
				CY%=CY%+IY%
				IP%=IP%+1
				PX(IP%)=CX%
				PY(IP%)=CY%
			END IF
		 END IF
	NEXT IJK%
END SUB
	SUB DELAY STATIC
'This subroutine is strictly for delay to avoid overrunning the plotter
'during critical initialization when executing the compiled version
	for dum!=0! to 1! step .01
		xdummy!=sin(dum!)
	next dUM!
	END SUB
	SUB InitializePlotter(ONLINE$,RT$,PCT(1),SPEED,FORCE, _
			OPT6%,OPT8%,XSHIFT,YSHIFT,P1X,P1Y,P2X,P2Y) Static
	DIM TPCT(12)
	TPCT(1)=.2:TPCT(2)=1!:TPCT(3)=1!: TPCT(4)=2!: TPCT(5)=2!: TPCT(6)=2!
	TPCT(7)=.4:TPCT(8)=2!:TPCT(9)=2!:TPCT(10)=3!:TPCT(11)=3!:TPCT(12)=3!
	IF ONLINE$="Y" THEN
		print #4,"IN;";CHR$(27);".L":input #4,L
		CALL DELAY
	ELSE
		PRINT #4,"IN;"
	END IF
	print #4,"RO;"
	IF RT$="Y" THEN
		print #4,"RO 90;"
	END IF
'IF ONLINE PLOTTER GET OPTIONS IMPLEMENTED ON THIS PLOTTER
	IF ONLINE$="Y" THEN
		print #4,"OO;"
		input #4,OPT1%,OPT2%,OPT3%,OPT4%,OPT5%,OPT6%,OPT7%,OPT8%
		CALL DELAY
	ELSE
		OPT6%=1
		OPT8%=1
	END IF
	IF ONLINE$="Y" THEN
		print #4,"IP;";CHR$(27);".L":INPUT #4,L
		print #4,"IW;";CHR$(27);".L":input #4,L
		CALL DELAY
	ELSE
		PRINT #4,"IP;IW;"
	END IF
'IF ONLINE PLOTTER GET SIZE OF PLOT P1,P2 AREA
	IF ONLINE$ = "Y" THEN
		print #4,"OP;"
		input #4,P1X,P1Y,P2X,P2Y
		CALL DELAY
	END IF
'OPT8% = 1 PLOTTER HAS CONFIGURABLE MEMORY
'DOWNLOAD SPECIAL CHARACTERS
	IF OPT8%=1 THEN
		print #4,CHR$(27)+".T1046;1778;600;0;44:"
		CALL DELAY
		print #4,CHR$(27)+".@1024:"
		CALL DELAY
		IF ONLINE$="Y" THEN
			print #4,"CS0;";CHR$(27);".L":input #4,L
		ELSE
			PRINT #4,"CS0;"
		END IF
		print #4,"CA -1;"
		print#4,"DL 64,0,32,32,32,-128,16,32,16,0,-128,16,20,29,20,32,17,32,13,29,10,16,10,-128,26,10,32,0;"
		print#4,"DL 38,2,0,2,32,-128,12,32,12,0,-128,0,32,26,32,30,30,32,26,32,23,30,18,26,16,2,16;"
		print#4,"DL 92,0,16,11,16,-128,27,25,26,27,25,30,22,32,13,32,9,29,7,25,5,21,5,11,10,2,12,0,22,0,25,2,26,4;"
		print#4,"DL 123,8,25,10,30,16,32,22,30,23,25,22,20,16,18,10,20,8,25;"
		print#4,"DL 125,17,20,20,30,-128,27,20,30,30;"
	ELSE
		print #4,CHR$(27)+".@1024;1:"
	END IF
	CALL DELAY
	IF P1X<0 AND P1Y<0 then
		XSHIFT=(P2X-P1X)/2
		YSHIFT=(P2Y-P1Y)/2
	ELSE
		XSHIFT=0
		YSHIFT=0
	END IF
SETSF:	print#4,"SS;"
	print #4,"VS "+STR$(SPEED)+";"
	print #4,"FS "+STR$(FORCE)+";"
	dist=SQR((P2X-P1X)^2 + (P2Y-P1Y)^2)
	pctfac=1934!/(.1*dist)
	for I%=1 to 12
		PCT(I%)=TPCT(I%)*pctfac
	next I%
END SUB
SUB SetPen(ipen%) Static
	PRINT#4,USING "SP #;";IPEN%
END SUB
SUB SetLine(Nline%,Pct(1)) Static
	Lt%=ABS(Nline%)
	if Nline%<-6 then Nline%=Nline%+6
	if (Nline%>6) then Nline%=Nline%-6
	if (Nline%=0) then
		print#4,"LT;"
	else
		print#4,using "LT ##, ###.###;";Nline%;Pct(Lt%)
	end if
END SUB
SUB SetCharSize(Wide!,High!) Static
	print#4,using "SI ###.###, ###.###;";Wide!;High!
END SUB
SUB SetCharDir(Degrees%) Static
	Th=0.01745329*Degrees%
	print#4,using "DI ###.###, ###.###;";cos(Th);sin(Th)
END SUB
SUB SetCharSlant(degrees%) Static
	Th=0.01745329*degrees%
	print#4,using "SL ###.###;";tan(Th)
END SUB
SUB SetMode(Itype%) Static
	if Itype% = 0 then
		print #4,"PA;"
	else
		print #4,"PR;"
	end if
END SUB
SUB SetPenStatus(Itype%) Static
	if Itype% = 0 then
		print #4,"PU;"
	else
		print #4,"PD;"
	end if
END SUB
SUB MoveTo(Itype%,x%,y%) Static
	CALL SetPenStatus(0)
	if Itype%=0 then
		print #4,"PA";x%;",";y%;";"
	else
		print #4,"PR";x%;",";y%;";"
	end if
END SUB
SUB LineTo(Itype%,x%,y%) Static
	CALL SetPenStatus(1)
	if Itype%=0 then
		print #4,"PA";x%;",";y%;";"
	else
		print #4,"PR";x%;",";y%;";"
	end if
END SUB
SUB DrawCharStr(CharStr$) Static
	print #4,CharStr$;
END SUB
SUB DrawCircle(Radius%) Static
	print #4,"CI";Radius%;",5;"
END SUB
SUB PolygonCode(Itype%) Static
		if Itype%=0 then print #4,"PM0;"
		if Itype%=1 then print #4,"PM1;"
		if Itype%=2 then print #4,"PM2;"
END SUB
SUB PolygonFill(FType%,Space%,Angle%) Static
	print #4,"FT";FType%;",";Space%;",";Angle%;";FP;"
END SUB
SUB PolygonEdge Static
	print #4,"EP;"
END SUB
